<?php 
    $wp_customize->add_section(
        'featuredproducts_area',
        array(
            'title' => __( 'Feature Products Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );

    $wp_customize->add_setting(
        'featuredproducts_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'featuredproducts_area_disable',
            array(
                'settings'      => 'featuredproducts_area_disable',
                'section'       => 'featuredproducts_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'featuredproductsus', 'featuredproducts_area', $color='#fff', get_template_directory_uri().'/images/default.png', 'img');


lzCustomLable($wp_customize, 'featuredproductsarea_padding', 'featuredproducts_area', 'Section Padding');

$wp_customize->add_setting(
    'featuredproducts_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'featuredproducts_areaTpadding',
    array(
        'settings'      => 'featuredproducts_areaTpadding',
        'section'       => 'featuredproducts_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'featuredproducts_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'featuredproducts_areaBpadding',
    array(
        'settings'      => 'featuredproducts_areaBpadding',
        'section'       => 'featuredproducts_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);



lzCustomLable($wp_customize, 'feature_headingtxt', 'featuredproducts_area', 'Section Heading');


$wp_customize->add_setting(
        'feature_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Featured Product', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'feature_title',
        array(
            'settings'      => 'feature_title',
            'section'       => 'featuredproducts_area',
            'type'          => 'text',
            'label'         => __( 'Heading', 'luzuk-premium' )
        )
    );
    
lzCustomLable($wp_customize, 'featuredproductsarea_clr', 'featuredproducts_area', 'Section Color');


addColorPalatOption($wp_customize, 'featuredproducts_area_headingClr', 'featuredproducts_area', 'Heading Color', '#202447');

addColorPalatOption($wp_customize, 'featuredproducts_area_s_ntgclr', 'featuredproducts_area', 'Sale Tag BG Color', '#fab915');

addColorPalatOption($wp_customize, 'featuredproducts_nw_ntgclr', 'featuredproducts_area', 'New Tag BG Color', '#202447');

addColorPalatOption($wp_customize, 'featuredproducts_area_s_ntgtxtclr', 'featuredproducts_area', 'Sale/New Tag Color', '#fff');


addColorPalatOption($wp_customize, 'featuredproducts_area_pagebxbg', 'featuredproducts_area', 'Box BG Color', '#202447');

addColorPalatOption($wp_customize, 'featuredproducts_area_pagetitle', 'featuredproducts_area', 'Product Title Color', '#fff');

addColorPalatOption($wp_customize, 'featuredproducts_area_priceClr', 'featuredproducts_area', 'Product Price Color', '#FAB915');

addColorPalatOption($wp_customize, 'featuredproducts_area_icnClr', 'featuredproducts_area', 'Product Icon Color', '#fff');

addColorPalatOption($wp_customize, 'featuredproducts_area_icnbgClr', 'featuredproducts_area', 'Product Icon BG Color', '#202447');