<?php 
    $wp_customize->add_section(
        'newarrival_area',
        array(
            'title' => __( 'New Arrival Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );

    $wp_customize->add_setting(
        'newarrival_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'newarrival_area_disable',
            array(
                'settings'      => 'newarrival_area_disable',
                'section'       => 'newarrival_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'newarrivalus', 'newarrival_area', $color='#fff', get_template_directory_uri().'/images/default.png', 'img');

lzCustomLable($wp_customize, 'newarrivalarea_padding', 'newarrival_area', 'Section Padding');

$wp_customize->add_setting(
    'newarrival_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newarrival_areaTpadding',
    array(
        'settings'      => 'newarrival_areaTpadding',
        'section'       => 'newarrival_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'newarrival_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newarrival_areaBpadding',
    array(
        'settings'      => 'newarrival_areaBpadding',
        'section'       => 'newarrival_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'newarrival_heading', 'newarrival_area', 'Section Heading');

$wp_customize->add_setting(
        'newarrival_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'New Arrival', 'luzuk-premium' )
        )
    );
    $wp_customize->add_control(
        'newarrival_title',
        array(
            'settings'      => 'newarrival_title',
            'section'       => 'newarrival_area',
            'type'          => 'text',
            'label'         => __( 'Heading', 'luzuk-premium' )
        )
    );

addColorPalatOption($wp_customize, 'newarrival_area_headingClr', 'newarrival_area', 'Heading Color', '#202447');

$wp_customize->add_setting(
    'narbx_image_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);

$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'narbx_image_heading',
        array(
            'settings'      => 'narbx_image_heading',
            'section'       => 'newarrival_area',
            'label'         => __( 'Section Left Image', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'narbx_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'narbx_image',
        array(
            'section' => 'newarrival_area',
            'settings' => 'narbx_image',
            'description' => __('Recommended Image Size: 437X755px', 'luzuk-premium')
        )
    )
);

lzCustomLable($wp_customize, 'newarrival_opcity', 'newarrival_area', 'Image Overlay Opacity');

$wp_customize->add_setting(
    'newarrival_imgopcity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.4', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newarrival_imgopcity',
    array(
        'settings'      => 'newarrival_imgopcity',
        'section'       => 'newarrival_area',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'newarrival_area_imgclr', 'newarrival_area', 'Image Opacity Color', '#202447');

lzCustomLable($wp_customize, 'newarrival_opcity', 'newarrival_area', 'Title setting');

$wp_customize->add_setting(
    'newarrival_titleopcity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.3', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newarrival_titleopcity',
    array(
        'settings'      => 'newarrival_titleopcity',
        'section'       => 'newarrival_area',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'newarrival_area_imgtiltbgclr', 'newarrival_area', 'Title BG Color', '#202447');

$wp_customize->add_setting(
    'nar_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'AIR VOLTAGE METR ', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'nar_title',
    array(
        'settings'      => 'nar_title',
        'section'       => 'newarrival_area',
        'type'          => 'text',
        'label'         => __( 'Image Title ', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'nar_title2',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( ' 10%OFF', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'nar_title2',
    array(
        'settings'      => 'nar_title2',
        'section'       => 'newarrival_area',
        'type'          => 'text',
        'label'         => __( 'Image Discount Text  ', 'Luzuk' )
    )
);


addColorPalatOption($wp_customize, 'newarrival_area_imgtiltclr', 'newarrival_area', 'Title  Color', '#fff');

lzCustomLable($wp_customize, 'newarrivalarea_clr', 'newarrival_area', 'Section Color');

addColorPalatOption($wp_customize, 'newarrival_area_s_ntgclr', 'newarrival_area', 'Sale Tag BG Color', '#FAB915');

addColorPalatOption($wp_customize, 'newarrival_area_nw_ntgclr', 'newarrival_area', 'New Tag BG Color', '#202447');

addColorPalatOption($wp_customize, 'newarrival_area_s_ntgtxtclr', 'newarrival_area', 'Sale & New Tag Color', '#fff');

addColorPalatOption($wp_customize, 'newarrival_area_bxclr', 'newarrival_area', 'Product Box Color', '#202447');

addColorPalatOption($wp_customize, 'newarrival_area_pagetitle', 'newarrival_area', 'Product Title Color', '#F8F8F8');

addColorPalatOption($wp_customize, 'newarrival_area_salepriceClr', 'newarrival_area', 'Product Price Color ', '#FAB915');

addColorPalatOption($wp_customize, 'newarrival_area_seebtntxtclr', 'newarrival_area', 'Button Icon Color ', '#202447');

addColorPalatOption($wp_customize, 'newarrival_area_seebtntxthvclr', 'newarrival_area', 'Button Icon Hover Color ', '#fff');

addColorPalatOption($wp_customize, 'newarrival_area_seebtnbgclr', 'newarrival_area', 'Button BG Color ', '#FAB915');