<?php 
    $wp_customize->add_section(
        'selling_area',
        array(
            'title' => __( 'Best Selling Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );

    $wp_customize->add_setting(
        'selling_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'selling_area_disable',
            array(
                'settings'      => 'selling_area_disable',
                'section'       => 'selling_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'sellingus', 'selling_area', $color='#fff', get_template_directory_uri().'/images/default.png', 'img');

lzCustomLable($wp_customize, 'sellingarea_padding', 'selling_area', 'Section Padding');

$wp_customize->add_setting(
    'selling_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'selling_areaTpadding',
    array(
        'settings'      => 'selling_areaTpadding',
        'section'       => 'selling_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'selling_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'selling_areaBpadding',
    array(
        'settings'      => 'selling_areaBpadding',
        'section'       => 'selling_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'sellingmiddle', 'selling_area', 'Section Middle Box');

backgroundManager($wp_customize, 'sellingmiddle', 'selling_area', $color='#fff', get_template_directory_uri().'/images/bestsellerbg.jpg', 'color');

lzCustomLable($wp_customize, 'selling_opacity', 'selling_area', 'Image Opacity');


$wp_customize->add_setting(
    'selling_imgopcity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.7', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'selling_imgopcity',
    array(
        'settings'      => 'selling_imgopcity',
        'section'       => 'selling_area',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'selling_area_imgclr', 'selling_area', 'Image Opacity Color', '#202447');

lzCustomLable($wp_customize, 'selling_heading', 'selling_area', 'Section Heading');

$wp_customize->add_setting(
        'selling_title',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Best Sellers', 'luzuk-premium' )
        )
    );
$wp_customize->add_control(
    'selling_title',
    array(
        'settings'      => 'selling_title',
        'section'       => 'selling_area',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'selling_area_headingClr', 'selling_area', 'Heading Color', '#fff');

$wp_customize->add_setting(
        'selling_txt',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
            'default'           => __( 'Selling fast!', 'luzuk-premium' )
        )
    );
$wp_customize->add_control(
    'selling_txt',
    array(
        'settings'      => 'selling_txt',
        'section'       => 'selling_area',
        'type'          => 'text',
        'label'         => __( 'Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'selling_area_imgtxtClr', 'selling_area', 'Image Text Color', '#fff');

lzCustomLable($wp_customize, 'sellbtn', 'selling_area' , 'Section Button');

$wp_customize->add_setting(
    'sellbtntxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'View All' )
    )
);
$wp_customize->add_control(
    'sellbtntxt',
    array(
        'settings'      => 'sellbtntxt',
        'section'       => 'selling_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting('sellbtnlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('sellbtnlink',
    array(
        'settings'      => 'sellbtnlink',
        'section'       => 'selling_area',
        'type'          => 'url',
        'label'         => __( 'Button Link', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'selling_area_tptxtClr', 'selling_area', 'Top Button Text Color', '#000');

addColorPalatOption($wp_customize, 'selling_area_tptxthvClr', 'selling_area', 'Top Button Text Hover Color', '#fff');

addColorPalatOption($wp_customize, 'selling_area_tpbtnbgClr', 'selling_area', 'Top Button BG Color', '#FAB915');

addColorPalatOption($wp_customize, 'selling_area_tpbtnbghvClr', 'selling_area', 'Top Button BG Hover Color', '#000');


lzCustomLable($wp_customize, 'sellingarea_clr', 'selling_area', 'Section Color');

addColorPalatOption($wp_customize, 'selling_area_s_ntgclr', 'selling_area', 'Sale Tag BG Color', '#FAB915');

addColorPalatOption($wp_customize, 'selling_area_nw_ntgclr', 'selling_area', 'New Tag BG Color', '#202447');

addColorPalatOption($wp_customize, 'selling_area_s_ntgtxtclr', 'selling_area', 'Sale/New Tag Color', '#fff');

addColorPalatOption($wp_customize, 'selling_area_pricebgClr', 'selling_area', 'Product Box BG Color', '#202447');

addColorPalatOption($wp_customize, 'selling_area_pagetitle', 'selling_area', 'Product Title Color', '#fff');

addColorPalatOption($wp_customize, 'selling_area_priceClr', 'selling_area', 'Product Price Color', '#FAB915');


addColorPalatOption($wp_customize, 'selling_area_arrowiconClr', 'selling_area', 'Slider Arrow Icon Color', '#000');

addColorPalatOption($wp_customize, 'selling_area_arrowicnhvClr', 'selling_area', 'Slider Arrow Icon Hover Color', '#fff');

addColorPalatOption($wp_customize, 'selling_area_arrowiconbgClr', 'selling_area', 'Slider Arrow Icon BG Color', '#FAB915');
