<?php  

$luzukSliderSingleChoice = getFitnessPostsType('slider');
$wp_customize->add_section(
	'slider_section',
	array(
		'title' => __( 'Slider Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel',
		'priority' =>18
	)
);
$wp_customize->add_setting(
	'slider_section_show_content',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'slider_section_show_content',
		array(
			'settings'      => 'slider_section_show_content',
			'section'       => 'slider_section',
			'label'         => __( 'Hide Title And Description On Slider', 'Luzuk' ),
			'on_off_label'  => array(
				'on' => __( 'No', 'Luzuk' ),
				'off' => __( 'Yes', 'Luzuk' )
			),
		)
	)
);
$wp_customize->add_setting('slider_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Info_Text( 
		$wp_customize,
		'slider_section_lbl',
		array(
			'settings'		=> 'slider_section_lbl',
			'section'		=> 'slider_section',
			'label'			=> __( 'Note:', 'Luzuk' ),	
			'description'	=> __( 'The page featured image works as a banner and the title & content work as a slider caption. You can add this from the Slider menu. <br/> Recommended Image Size: 1500X556', 'Luzuk' ),
		)
	)
);


lzCustomLable($wp_customize, 'luzuk_sliderotherclrs', 'slider_section', 'Slider Color');

lzCustomLable($wp_customize, 'slider_opcity', 'slider_section', 'Image Overlay Opacity');

$wp_customize->add_setting(
    'slider_imgopcity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.8', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'slider_imgopcity',
    array(
        'settings'      => 'slider_imgopcity',
        'section'       => 'slider_section',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'slider_section_imgclr', 'slider_section', 'Overlay Opacity Color', '#202447');


addColorPalatOption($wp_customize, 'slider_titleClr', 'slider_section', 'Slider Title Color', '#fff');

addColorPalatOption($wp_customize, 'slider_titlehgbgClr', 'slider_section', 'Slider Title Highlight BG Color', '#FAB915');

addColorPalatOption($wp_customize, 'slider_txtClr', 'slider_section', 'Slider Text Color', '#fff');

addColorPalatOption($wp_customize, 'slider_btntxtClr', 'slider_section', 'Slider Button Text Color', '#FAB915');

addColorPalatOption($wp_customize, 'slider_btntxthvClr', 'slider_section', 'Slider Button Text Hover Color', '#000');

addColorPalatOption($wp_customize, 'slider_btnicnClr', 'slider_section', 'Slider Button Icon Color', '#FAB915');

addColorPalatOption($wp_customize, 'slider_btnicnbrdClr', 'slider_section', 'Slider Button Icon Border Color', '#FAB915');

addColorPalatOption($wp_customize, 'slider_btnicnbgClr', 'slider_section', 'Slider Button Icon BG Color', '#fff');

addColorPalatOption($wp_customize, 'slider_btnbgClr', 'slider_section', 'Slider Button BG Color', '#202447');

addColorPalatOption($wp_customize, 'slider_btnbghvClr', 'slider_section', 'Slider Button BG Hover Color', '#FAB915');


lzCustomLable($wp_customize, 'luzuk_sliderbutnclrs', 'slider_section', 'Slider Dot Color');

addColorPalatOption($wp_customize, 'sli_dotbgclr', 'slider_section', 'Slider Dot BG Color', '#202447');

addColorPalatOption($wp_customize, 'sli_dotbgactclr', 'slider_section', 'Slider Active Dot BG Color', '#202447');

addColorPalatOption($wp_customize, 'sli_dotbrdactclr', 'slider_section', 'Slider Active Dot Border Color', '#FAB915');