
<?php
/**
 * Template for displaying single product pages.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.0.0
 */
get_header(); ?>
<div class="clearfix"></div>

	
<div class="single-productpage">
	<main id="innerpage-box">
		<div id="page" class="container" >
			<div class="inner_contentbox" >		
				<article id="content" class="article single_inner ">	
					<div class="row mr-0">	
							
						<!-- <div class="col-lg-9 col-md-8"> -->
					<!-- Display Related Products -->
						    <div class="woocommerce-related-products">
						    	<!-- </?php do_action('woocommerce_before_main_content'); ?> -->
								<?php while ( have_posts() ) : the_post(); ?>
								<?php wc_get_template_part( 'content', 'single-product' ); ?>
							<?php endwhile;  ?> 
					
						<?php
							if ( ! defined( 'ABSPATH' ) ) {
								exit; // Exit if accessed directly
							}
							global $product;

							// Product Description
							echo '<div class="woocommerce-product-details__description">';
							echo '<h6>Description</h6>';
							echo apply_filters( 'woocommerce_short_description', $product->get_description() );
							echo '</div>';

							// Product Additional Information
							echo '<div class="woocommerce-product-additional-information">';
							echo '<h6>About This Item</h6>';
							do_action('woocommerce_product_additional_information', $product);
							echo '</div>';

							// Product Reviews
							if ( comments_open() || get_comments_number() ) {
								echo '<div class="woocommerce-product-reviews">';
								echo '<h2 class="woo-reviews">Customer Review</h2>';
								comments_template();
								echo '</div>';
							}
						?>
						    	<div class="related-products-button">
							        <?php
								        if ( function_exists( 'wc_get_page_id' ) && is_product() ) {
								            global $product;
								            
								            // Get related products IDs
								            $related_products = wc_get_related_products($product->get_id(), 4); // Retrieve 4 related product IDs

								            // Only show the "See All" button if there are related products
								            if (!empty($related_products)) {
								                $shop_page_url = get_permalink( wc_get_page_id( 'shop' ) );
								                echo '<a href="' . esc_url( $shop_page_url ) . '" class="button">See All</a>';
								            }
								        }
							        ?>
							    </div>
						        <?php
						            woocommerce_related_products(array(
						                'posts_per_page' => 4,
						                'columns'        => 4,
						                'orderby'        => 'date' 
						            ));
						        ?>
						    </div>
						    <div class="clearfix"></div>
						<!-- </div> -->
						<!-- <div class="col-lg-3 col-md-4">
							<div id="secondary" class="widget-area">
			        			<//?php dynamic_sidebar('luzuk-single-product-pg-sidebar'); ?>
			        		</div>
						</div> -->
						
					</div>
					<div class="clearfix"></div>
				</article>	
			</div>
		</div>
  	</main><!-- #primary -->	
</div>
<?php get_footer(); ?>
