<?php 
    $wp_customize->add_section(
        'about_area',
        array(
            'title' => __( 'About Us Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    $wp_customize->add_setting(
        'about_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'about_area_disable',
            array(
                'settings'      => 'about_area_disable',
                'section'       => 'about_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'aboutus', 'about_area', $color='#1C202B', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'aboutarea_padding', 'about_area', 'Section Padding');

$wp_customize->add_setting(
    'about_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaTpadding',
    array(
        'settings'      => 'about_areaTpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'about_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_areaBpadding',
    array(
        'settings'      => 'about_areaBpadding',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);



lzCustomLable($wp_customize, 'aboutarea_rightclr', 'about_area', 'Section Left Side');

$wp_customize->add_setting(
    'about_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Hello And Welcome !', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_title',
    array(
        'settings'      => 'about_title',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Title', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_sectitle_clr', 'about_area', 'Section Title Color ', '#fff');

$wp_customize->add_setting(
    'about_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem Ipsum Is Simply Dummy Text Of The Printing And Typesetting Industry. Lorem Ipsum Has Been The Industry is Standard Dummy Text Ever Since The 1500S, When An Unknown Printer Took A Galley Of Type And Scrambled It To Make A Type Specimen Book.', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'about_text',
    array(
        'settings'      => 'about_text',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( 'Section Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'about_area_text', 'about_area', 'Section Text Color', '#fff');


$wp_customize->add_setting('aboutus_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'aboutus_npp_heading',
        array(
            'settings'      => 'aboutus_npp_heading',
            'section'       => 'about_area',
            'label'         => __( 'Number Of About Plans', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('aboutus_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 1));
$wp_customize->add_control(
    'aboutus_npp_count',
    array(
        'settings'      => 'aboutus_npp_count',
        'section'       => 'about_area',
        'type'          => 'select',
        'label'         => __( 'Number Of About Plan To Show', 'luzuk-premium' ),
        'choices'=>array(1,2,3,4,5,6)
    )
);

//ABOUT PAGES
for( $i = 1; $i <= 6; $i++ ){
    $wp_customize->add_setting(
        'aboutus_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'aboutus_header'.$i,
            array(
                'settings'      => 'aboutus_header'.$i,
                'section'       => 'about_area',
                'label'         => __( 'About Plan ', 'luzuk-premium' ).$i
            )
        )
    );

//lzAddImageElement($wp_customize, 'aboutus_page_icon'.$i, 'about_area', $label="Recommended Image Size: 150X150px");

     $wp_customize->add_setting(
        'aboutus_page_icon'.$i,
        array(
            'default'           => 'fa fa-joomla',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'aboutus_page_icon'.$i,
            array(
                'settings'      => 'aboutus_page_icon'.$i,
                'section'       => 'about_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );

lzAddElement($wp_customize, 'aboutus_page_title'.$i, 'about_area', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Harmonize Your Energy, Heal Your');

//lzAddElement($wp_customize, 'aboutus_page_txt'.$i, 'about_area', $type = 'textarea', $label="Text", $callback ='luzuk_sanitize_text', $default='There are many variations of passages of Lorem');

}

lzCustomLable($wp_customize, 'Sec_abtclor', 'about_area' , 'About Section Color');

addColorPalatOption($wp_customize, 'about_area_pagebxicn', 'about_area', 'Section Icon Color', '#E3394D');

addColorPalatOption($wp_customize, 'about_area_pagetitle', 'about_area', 'Section Icon Title Color', '#fff');

lzCustomLable($wp_customize, 'Sec_notice', 'about_area' , 'Notice Box');

$wp_customize->add_setting(
    'nbxtle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Let Me ', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'nbxtle',
    array(
        'settings'      => 'nbxtle',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Notice Box Title', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'hnbxtle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Help You :', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'hnbxtle',
    array(
        'settings'      => 'hnbxtle',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Notice Box Highlight Title', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'nbxlist',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '<li>Feel Empowered With Your Physical And Emotional Health</li> 
<li>Reconnect To That State Of Balance, Joy, And Inner Peace</li> 
<li>Re-Connect To The Innate Healing Power That Exists Within You</li> ', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'nbxlist',
    array(
        'settings'      => 'nbxlist',
        'section'       => 'about_area',
        'type'          => 'textarea',
        'label'         => __( 'Notice Box Text', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'abtSec_noticeclor', 'about_area' , 'Notice Content Box Color');

addColorPalatOption($wp_customize, 'about_area_nbxtitle', 'about_area', 'Notice Box Title Color', '#fff');

addColorPalatOption($wp_customize, 'about_area_nbxhightitle', 'about_area', 'Notice Box Highlight Title Color', '#E3394D');

addColorPalatOption($wp_customize, 'about_area_nbxicn', 'about_area', 'Notice Box Icon Color', '#000');

addColorPalatOption($wp_customize, 'about_area_nbxicnbg', 'about_area', 'Notice Box Icon BG Color', '#E3394D');

addColorPalatOption($wp_customize, 'about_area_nbxtxt', 'about_area', 'Notice Box Text Color', '#fff');


lzCustomLable($wp_customize, 'abtSec_btnclor', 'about_area' , 'Section Button');

$wp_customize->add_setting(
    'abtbtn_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'About Me', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'abtbtn_text',
    array(
        'settings'      => 'abtbtn_text',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

$wp_customize->add_setting('abtbtnlink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('abtbtnlink',
    array(
        'settings'      => 'abtbtnlink',
        'section'       => 'about_area',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'abtdec_btntxtclr', 'about_area', 'Button Text Color', '#000');

addColorPalatOption($wp_customize, 'abtdec_btntxthvclr', 'about_area', 'Button Text Hover Color', '#E3394D');

addColorPalatOption($wp_customize, 'abtdec_btnBGclr', 'about_area', 'Button BG Color', '#fff');

addColorPalatOption($wp_customize, 'abtdec_btnBGhvclr', 'about_area', 'Button BG Hover Color', '#E3394D');

$wp_customize->add_setting(
    'about_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_title_heading',
        array(
            'settings'      => 'about_title_heading',
            'section'       => 'about_area',
            'label'         => __( ' Section Right Side', 'luzuk-premium' ),
        )
    )
);    


$wp_customize->add_setting(
    'about_image_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'about_image_heading',
        array(
            'settings'      => 'about_image_heading',
            'section'       => 'about_area',
            'label'         => __( 'Section Image', 'luzuk-premium' ),
        )
    )
);

$wp_customize->add_setting(
    'about_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'about_image',
        array(
            'section' => 'about_area',
            'settings' => 'about_image',
            'description' => __('Recommended Image Size: 590X590px', 'luzuk-premium')
        )
    )
);

$wp_customize->add_setting(
    'imgyear',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '5', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'imgyear',
    array(
        'settings'      => 'imgyear',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Number ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'YEARS',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Year', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'YEARS',
    array(
        'settings'      => 'YEARS',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Years Text', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'EXPEtxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Experience', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'EXPEtxt',
    array(
        'settings'      => 'EXPEtxt',
        'section'       => 'about_area',
        'type'          => 'text',
        'label'         => __( 'Experience Text', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'about_secsimgTxtbg', 'about_area', 'Section Image Text BG Color ', '#E3394D');

addColorPalatOption($wp_customize, 'about_secsimgTxt', 'about_area', 'Section Image Text Color ', '#fff');