<?php
$wp_customize->add_section(
    'banner_section',
    array(
        'title' => __( 'Banner Section', 'Luzuk' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);

$wp_customize->add_setting(
    'banner_section_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'banner_section_disable',
        array(
            'settings'      => 'banner_section_disable',
            'section'       => 'banner_section',
            'label'         => __( 'Disable Section', 'Luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'Luzuk' ),
                'off' => __( 'No', 'Luzuk' )
            ),
        )
    )
);


BackgroundManager($wp_customize, 'banner', 'banner_section', $color='#1C202B', get_template_directory_uri().'/images/banner3.jpg', 'color');

lzCustomLable($wp_customize, 'sec_bannerpadding', 'banner_section', 'Section Padding');

$wp_customize->add_setting(
    'bannerTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'bannerTpadding',
    array(
        'settings'      => 'bannerTpadding',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Top', 'Luzuk' )
    )
);
$wp_customize->add_setting(
    'bannerBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '7em', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'bannerBpadding',
    array(
        'settings'      => 'bannerBpadding',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'Luzuk' )
    )
);


$wp_customize->add_setting(
    'banner_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'banner_title_heading',
        array(
            'settings'      => 'banner_title_heading',
            'section'       => 'banner_section',
            'label'         => __( 'Section Heading ', 'Luzuk' ),
        )
    )
);  

$wp_customize->add_setting(
    'banner_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Get', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'banner_title',
    array(
        'settings'      => 'banner_title',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Section Heading ', 'Luzuk' )
    )
);

$wp_customize->add_setting(
    'banner_extitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Discount For All Classes', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'banner_extitle',
    array(
        'settings'      => 'banner_extitle',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Section 2nd Heading ', 'Luzuk' )
    )
); 

addColorPalatOption($wp_customize, 'banner_headclr', 'banner_section', 'Heading Color', '#000'); 

$wp_customize->add_setting(
    'banner_sub_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '25%', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'banner_sub_title',
    array(
        'settings'      => 'banner_sub_title',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Section Discount Text ', 'Luzuk' )
    )
); 

addColorPalatOption($wp_customize, 'banner_subheadingclr', 'banner_section', 'Discount Text Color', '#E3394D'); 

$wp_customize->add_setting(
    'banner_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'banner_text',
    array(
        'settings'      => 'banner_text',
        'section'       => 'banner_section',
        'type'          => 'textarea',
        'label'         => __( 'Section Text ', 'Luzuk' )
    )
); 

addColorPalatOption($wp_customize, 'banner_textclr', 'banner_section', 'Text Color', '#908686'); 

$wp_customize->add_setting(
    'btn_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Join Now', 'Luzuk' )
    )
);
$wp_customize->add_control(
    'btn_text',
    array(
        'settings'      => 'btn_text',
        'section'       => 'banner_section',
        'type'          => 'text',
        'label'         => __( 'Button Text ', 'Luzuk' )
    )
);

$wp_customize->add_setting('banner_btnlink',   
    array('default'=> 'Add Link', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('banner_btnlink',
    array(
        'settings'      => 'banner_btnlink',
        'section'       => 'banner_section',
        'type'          => 'url',
        'label'         => __( 'Button Link ', 'luzuk-premium' )
    )
);

lzCustomLable($wp_customize, 'bannerl_btnclrset', 'banner_section', 'Button Setting');


addColorPalatOption($wp_customize, 'banner_btntxtclr', 'banner_section', 'Button Text Color', '#fff'); 

addColorPalatOption($wp_customize, 'banner_btntxthvclr', 'banner_section', 'Button Text Hover Color', '#000'); 

addColorPalatOption($wp_customize, 'banner_btnbgclr', 'banner_section', 'Button BG Color', '#E3394D'); 

addColorPalatOption($wp_customize, 'banner_btnbghvclr', 'banner_section', 'Button BG Hover Color', '#000'); 