<?php
/**
 * Createing an benefits pannel for customizer
 *
 */

// START benefits SECTION 
    $wp_customize->add_section(
        'luzuk_premium_benefits',
        array(
            'title' => __( 'Benefits Section', 'luzuk premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    // ENABLE/DISABLE FEATURED SECTION
    $wp_customize->add_setting(
        'luzuk_premium_benefits_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'luzuk_premium_benefits_disable',
            array(
                'settings'      => 'luzuk_premium_benefits_disable',
                'section'       => 'luzuk_premium_benefits',
                'label'         => __( 'Disable Section', 'luzuk premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk premium' ),
                    'off' => __( 'No', 'luzuk premium' )
                ),
            )
        )
    );


backgroundManager($wp_customize, 'benefits', 'luzuk_premium_benefits', $color='#1C202B');

lzCustomLable($wp_customize, 'luzuk_sec_benefitssectionpadding', 'luzuk_premium_benefits', 'Section Padding');

$wp_customize->add_setting(
    'benefits_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '8em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'benefits_areaTpadding',
    array(
        'settings'      => 'benefits_areaTpadding',
        'section'       => 'luzuk_premium_benefits',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'benefits_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '1em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'benefits_areaBpadding',
    array(
        'settings'      => 'benefits_areaBpadding',
        'section'       => 'luzuk_premium_benefits',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'benefits_title_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'benefits_title_heading',
        array(
            'settings'      => 'benefits_title_heading',
            'section'       => 'luzuk_premium_benefits',
            'label'         => __( 'Section Heading & Sub Heading', 'luzuk' ),
        )
    )
);  

$wp_customize->add_setting(
    'benefits_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'MEDITATION AND REIKI BENEFITS', 'luzuk' )
    )
);
$wp_customize->add_control(
    'benefits_title',
    array(
        'settings'      => 'benefits_title',
        'section'       => 'luzuk_premium_benefits',
        'type'          => 'text',
        'label'         => __( 'Heading', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'benefits_secheadingClr', 'luzuk_premium_benefits', 'Heading Color', '#fff');


$wp_customize->add_setting(
    'benefits_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Meditation and Reiki are two distinct practices, each with its own set of benefits. Let us explore the benefits of each practice individually:', 'luzuk' )
    )
);
$wp_customize->add_control(
    'benefits_subtitle',
    array(
        'settings'      => 'benefits_subtitle',
        'section'       => 'luzuk_premium_benefits',
        'type'          => 'textarea',
        'label'         => __( 'Sub Heading', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'benefits_secsubheadingClr', 'luzuk_premium_benefits', 'Sub Heading Color', '#7f7d7d');


// RHS

lzCustomLable($wp_customize, 'luzuk_benefitlhs', 'luzuk_premium_benefits', ' Left Side');

$wp_customize->add_setting(
    'lhstitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'MEDITATION', 'luzuk' )
    )
);
$wp_customize->add_control(
    'lhstitle',
    array(
        'settings'      => 'lhstitle',
        'section'       => 'luzuk_premium_benefits',
        'type'          => 'text',
        'label'         => __( 'Left Box Heading', 'luzuk' )
    )
);

$wp_customize->add_setting('luzuk_benefits_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'luzuk_benefits_npp_heading',
        array(
            'settings'      => 'luzuk_benefits_npp_heading',
            'section'       => 'luzuk_premium_benefits',
            'label'         => __( 'Number Of Plans', 'luzuk' ),
        )
    )
);    
$wp_customize->add_setting('luzuk_benefits_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 1));
$wp_customize->add_control(
    'luzuk_benefits_npp_count',
    array(
        'settings'      => 'luzuk_benefits_npp_count',
        'section'       => 'luzuk_premium_benefits',
        'type'          => 'select',
        'label'         => __( 'Number Of Plan To Show', 'luzuk' ),
        'choices'=>array(1,2,3,4)
    )
);

//FEATURED PAGES
for( $i = 1; $i <= 4; $i++ ){
    $wp_customize->add_setting(
        'luzuk_benefits_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_benefits_header'.$i,
            array(
                'settings'      => 'luzuk_benefits_header'.$i,
                'section'       => 'luzuk_premium_benefits',
                'label'         => __( 'Left Side Box ', 'luzuk' ).$i
            )
        )
    );

   

lzAddElement($wp_customize, 'luzuk_benefits_page_title_'.$i, 'luzuk_premium_benefits', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Improved Focus And Concentration');

lzAddElement($wp_customize, 'benefits_txt'.$i, 'luzuk_premium_benefits', $type = 'textarea', $label="Text", $callback ='luzuk_sanitize_text', $default='Regular Meditation Practice Has Been Shown To Enhance Cognitive Abilities Such As Focus, Attention, And Concentration. This Can Be Particularly Useful In Daily Tasks And Work.');

}


// RHS

lzCustomLable($wp_customize, 'luzuk_benefitsrhs', 'luzuk_premium_benefits', ' Right Side');

$wp_customize->add_setting(
    'Rhs_title',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'REIKI', 'luzuk' )
    )
);
$wp_customize->add_control(
    'Rhs_title',
    array(
        'settings'      => 'Rhs_title',
        'section'       => 'luzuk_premium_benefits',
        'type'          => 'text',
        'label'         => __( 'Right Box Heading', 'luzuk' )
    )
);

$wp_customize->add_setting('luzuk_benefits_npp_rhs_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'luzuk_benefits_npp_rhs_heading',
        array(
            'settings'      => 'luzuk_benefits_npp_rhs_heading',
            'section'       => 'luzuk_premium_benefits',
            'label'         => __( 'Number Of Plans', 'luzuk' ),
        )
    )
);    
$wp_customize->add_setting('luzuk_benefits_npp_countRhs',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 1));
$wp_customize->add_control(
    'luzuk_benefits_npp_countRhs',
    array(
        'settings'      => 'luzuk_benefits_npp_countRhs',
        'section'       => 'luzuk_premium_benefits',
        'type'          => 'select',
        'label'         => __( 'Number Of Plan To Show', 'luzuk' ),
        'choices'=>array(1,2,3,4)
    )
);

//FEATURED PAGES
for( $i = 1; $i <= 4; $i++ ){
    $wp_customize->add_setting(
        'luzuk_benefits_header_rhs'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_benefits_header_rhs'.$i,
            array(
                'settings'      => 'luzuk_benefits_header_rhs'.$i,
                'section'       => 'luzuk_premium_benefits',
                'label'         => __( 'RIght Side Box ', 'luzuk' ).$i
            )
        )
    );

   

lzAddElement($wp_customize, 'benefits_R_title'.$i, 'luzuk_premium_benefits', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Relaxation And Stress Reduction');

lzAddElement($wp_customize, 'benefits_R_txt'.$i, 'luzuk_premium_benefits', $type = 'textarea', $label="Text", $callback ='luzuk_sanitize_text', $default='Reiki Sessions Are Often Deeply Relaxing, Which Can Help Reduce Stress, Anxiety, And Promote A Sense Of Calm.');

}

lzCustomLable($wp_customize, 'luzuk_benefitscolor', 'luzuk_premium_benefits', ' Section Color');

addColorPalatOption($wp_customize, 'benefits_bxtitleClr', 'luzuk_premium_benefits', 'Title Color', '#F63954');

addColorPalatOption($wp_customize, 'benefits_bxtitlebrdClr', 'luzuk_premium_benefits', 'Title Border Color', '#F63954');

addColorPalatOption($wp_customize, 'benefits_IconClr', 'luzuk_premium_benefits', 'Icon Color', '#F63954');

addColorPalatOption($wp_customize, 'benefits_titleClr', 'luzuk_premium_benefits', 'Icon Title Color', '#fff');

addColorPalatOption($wp_customize, 'benefits_txtClr', 'luzuk_premium_benefits', 'Icon Text Color', '#7f7d7d');

