<?php 
$wp_customize->add_section(
    'course_area',
    array(
        'title'         => __( 'Courses Section', 'luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
$wp_customize->add_setting(
    'course_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'course_area_disable',
        array(
            'settings'      => 'course_area_disable',
            'section'       => 'course_area',
            'label'         => __( 'Disable Section', 'luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk' ),
                'off' => __( 'No', 'luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'coursesec', 'course_area', $color='#1C202B', get_template_directory_uri().'/images/default.png', 'img');

lzCustomLable($wp_customize, 'luzuk_sec_coursespd', 'course_area', 'Section Padding');

$wp_customize->add_setting(
    'course_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'course_areaTpadding',
    array(
        'settings'      => 'course_areaTpadding',
        'section'       => 'course_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'course_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '6em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'course_areaBpadding',
    array(
        'settings'      => 'course_areaBpadding',
        'section'       => 'course_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'courses_maintitle_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'courses_maintitle_subtitle_heading',
        array(
            'settings'      => 'courses_maintitle_subtitle_heading',
            'section'       => 'course_area',
            'label'         => __( 'Section Sub Heading & Heading', 'luzuk' ),
        )
    )
);

$wp_customize->add_setting(
    'coursesubtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Some Of Our Courses', 'luzuk' )
    )
);
$wp_customize->add_control(
    'coursesubtitle',
    array(
        'settings'      => 'coursesubtitle',
        'section'       => 'course_area', 
        'type'          => 'text',
        'label'         => __( 'Section Sub Heading', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'coursesec_subheading_clr', 'course_area', 'Section Sub Heading Color ', '#DA384A');


$wp_customize->add_setting(
    'courses_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Choose Your Level Best', 'luzuk' )
    )
);
$wp_customize->add_control(
    'courses_maintitle',
    array(
        'settings'      => 'courses_maintitle',
        'section'       => 'course_area', 
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'coursesec_heading_clr', 'course_area', 'Section Heading Color ', '#fff');



$wp_customize->add_setting('course_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'course_area_lbl2',
        array(
            'settings'      => 'course_area_lbl2',
            'section'       => 'course_area',
            'label'         => __( 'Note 2 :', 'luzuk' ),  
            'description'   => __( 'Use Shortcode [COURSES] to show all courses in a page', 'luzuk' ),
        )
    )
);


$wp_customize->add_setting('course_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'course_npp_heading',
        array(
            'settings'      => 'course_npp_heading',
            'section'       => 'course_area',
            'label'         => __( 'Number Of Courses To Show', 'luzuk' ),
        )
    )
);    
$wp_customize->add_setting('course_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 2));
$wp_customize->add_control(
    'course_npp_count',
    array(
        'settings'      => 'course_npp_count',
        'section'       => 'course_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Courses To Show', 'luzuk' ),
        'choices'=>array(1,2,3,4,5,6)
    )
);

$CoursesSingleChoice[] = 'Select';

for( $i = 1; $i <= 6; $i++ ){
    $wp_customize->add_setting(
        'courses_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'courses_heading'.$i,
            array(
                'settings'      => 'courses_heading'.$i,
                'section'       => 'course_area',
                'label'         => __( 'Course ', 'luzuk' ).$i,
            )
        )
    );
    if(is_array($CoursesSingleChoice)){
        $wp_customize->add_setting(
            'courses_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'courses_page'.$i,
            array(
                'settings'      => 'courses_page'.$i,
                'section'       => 'course_area',
                'type'=> 'select',
                'label'         => __( 'Select A Course Box ', 'luzuk' ),
                'choices' => $CoursesSingleChoice,
            )
        );

// $wp_customize->add_setting(
//         'courses_page_icon1'.$i,
//         array(
//             'default'           => 'fa fa-home',
//             'sanitize_callback' => 'luzuk_sanitize_text'
//         )
//     );        
//     $wp_customize->add_control(
//         new luzuk_Fontawesome_Icon_Choocourse(
//             $wp_customize,
//             'courses_page_icon1'.$i,
//             array(
//                 'settings'      => 'courses_page_icon1'.$i,
//                 'section'       => 'course_area',
//                 'type'          => 'icon',
//                 'label'         => __( 'FontAwesome Icon', 'luzuk' ),
//             )
//         )
//     );



    }else{
        $wp_customize->add_setting('course_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'course_area_lbl'.$i,
                array(
                    'settings'      => 'course_area_lbl'.$i,
                    'section'       => 'course_area',
                    'label'         => __( 'Note:', 'luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the course Page.</strong> <br/>Please add the courses from "courses menu" and then select courses to show information.', 'luzuk' ),
                )
            )
        );
    }
}

lzCustomLable($wp_customize, 'luzuk_sec_coursesclr', 'course_area', 'Course Section Color');

addColorPalatOption($wp_customize, 'courses_bxclrclr', 'course_area', 'Section Box Color', '#fff');

addColorPalatOption($wp_customize, 'courses_sttxtclr', 'course_area', 'Section Trainer Name & Icon  Color', '#000');

addColorPalatOption($wp_customize, 'courses_sttxtbgclr', 'course_area', 'Section Trainer Name BG Color', '#fff');

addColorPalatOption($wp_customize, 'courses_sttxtbghvclr', 'course_area', 'Section Trainer Name BG Hover Color', '#DC3545');

addColorPalatOption($wp_customize, 'courses_titlclr', 'course_area', 'Section Title Color', '#000');

addColorPalatOption($wp_customize, 'courses_titlhvclr', 'course_area', 'Section Title Hover Color', '#DC3545');

addColorPalatOption($wp_customize, 'courses_txtclr', 'course_area', 'Section Text Color', '#8d8989');

addColorPalatOption($wp_customize, 'courses_sticnclr', 'course_area', 'Section Day & Time Icon Color', '#DC3545');

addColorPalatOption($wp_customize, 'courses_sticntxtclr', 'course_area', 'Section Day & Time Text Color', '#000');

addColorPalatOption($wp_customize, 'courses_catclr', 'course_area', 'Section Categories Text Color', '#fff');

addColorPalatOption($wp_customize, 'courses_1bxcatbgclr', 'course_area', 'Section 1st Box Categories Text BG Color', '#17A2B8');

addColorPalatOption($wp_customize, 'courses_5bxcatbgclr', 'course_area', 'Section 2nd Box Categories Text BG Color', '#DC3545');

//addColorPalatOption($wp_customize, 'courses_3bxcatbgclr', 'course_area', 'Section 3rd & 6th Box categories Text BG Color', '#28A745');