<?php 
    $wp_customize->add_section(
        'features_area',
        array(
            'title' => __( 'Feature Section', 'luzuk-premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );

    $wp_customize->add_setting(
        'features_area_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'features_area_disable',
            array(
                'settings'      => 'features_area_disable',
                'section'       => 'features_area',
                'label'         => __( 'Disable Section', 'luzuk-premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk-premium' ),
                    'off' => __( 'No', 'luzuk-premium' )
                ),
            )
        )
    ); 

backgroundManager($wp_customize, 'featuresus', 'features_area', $color='#1C202B', get_template_directory_uri().'/images/default.png', 'img');

lzCustomLable($wp_customize, 'featuresarea_padding', 'features_area', 'Section Padding');

$wp_customize->add_setting(
    'features_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '3em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'features_areaTpadding',
    array(
        'settings'      => 'features_areaTpadding',
        'section'       => 'features_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'features_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'features_areaBpadding',
    array(
        'settings'      => 'features_areaBpadding',
        'section'       => 'features_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'fea_maintitle_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'fea_maintitle_subtitle_heading',
        array(
            'settings'      => 'fea_maintitle_subtitle_heading',
            'section'       => 'features_area',
            'label'         => __( 'Section Sub Heading & Heading', 'luzuk' ),
        )
    )
);

$wp_customize->add_setting(
    'fea_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Types Of Meditation', 'luzuk' )
    )
);
$wp_customize->add_control(
    'fea_subtitle',
    array(
        'settings'      => 'fea_subtitle',
        'section'       => 'features_area', 
        'type'          => 'text',
        'label'         => __( 'Section Sub Heading ', 'luzuk' )
    )
);


addColorPalatOption($wp_customize, 'features_ltxt', 'features_area', 'Section Sub Heading Color', '#DA384A');

$wp_customize->add_setting(
    'fea_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'There Are Many Different Forms Of Meditation', 'luzuk' )
    )
);
$wp_customize->add_control(
    'fea_maintitle',
    array(
        'settings'      => 'fea_maintitle',
        'section'       => 'features_area', 
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'features_area_heading', 'features_area', 'Section Heading Color', '#fff');



// Left Side
// *********

lzCustomLable($wp_customize, 'abtright', 'features_area' , 'Left Side');

$wp_customize->add_setting('featuresus_npp_headingleft',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'featuresus_npp_headingleft',
        array(
            'settings'      => 'featuresus_npp_headingleft',
            'section'       => 'features_area',
            'label'         => __( 'Number Of Feature Left PLan ', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('featuresus_npp_countleft',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 2));
$wp_customize->add_control(
    'featuresus_npp_countleft',
    array(
        'settings'      => 'featuresus_npp_countleft',
        'section'       => 'features_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Feature Left PLan To Show ', 'luzuk-premium' ),
        'choices'=>array(1,2,3)
    )
);

//features PAGES
for( $i = 1; $i <= 3; $i++ ){
    $wp_customize->add_setting(
        'featuresus_headerleft'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'featuresus_headerleft'.$i,
            array(
                'settings'      => 'featuresus_headerleft'.$i,
                'section'       => 'features_area',
                'label'         => __( 'Feature Left PLan ', 'luzuk-premium' ).$i
            )
        )
    );

     $wp_customize->add_setting(
        'featuresus_page_left_icon'.$i,
        array(
            'default'           => 'fa fa-empire',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'featuresus_page_left_icon'.$i,
            array(
                'settings'      => 'featuresus_page_left_icon'.$i,
                'section'       => 'features_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );


lzAddElement($wp_customize, 'featuresus_page_titleleft'.$i, 'features_area', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Chakra Meditation');

lzAddElement($wp_customize, 'featuresus_page_textleft'.$i, 'features_area', $type = 'textarea', $label="Text", $callback ='luzuk_sanitize_text', $default='Lorem Ipsum is simply dummy text of the printing and typesetting');

}

// Middle

lzCustomLable($wp_customize, 'feaimg', 'features_area' , 'Section Image');

$wp_customize->add_setting(
    'fea_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'fea_image',
        array(
            'section' => 'features_area',
            'settings' => 'fea_image',
            'description' => __('Recommended Image Size: 394X594px', 'luzuk-premium')
        )
    )
);

lzCustomLable($wp_customize, 'feabtn', 'features_area' , 'Section Button');

$wp_customize->add_setting(
    'feabtntxt',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'See Out MORE' )
    )
);
$wp_customize->add_control(
    'feabtntxt',
    array(
        'settings'      => 'feabtntxt',
        'section'       => 'features_area',
        'type'          => 'text',
        'label'         => __( 'Section Button Text', 'luzuk-premium' )
    )
);
$wp_customize->add_setting('feabtnlink',   array('default'=> 'add link here', 'sanitize_callback' => 'esc_url_raw'));
$wp_customize->add_control('feabtnlink',
    array(
        'settings'      => 'feabtnlink',
        'section'       => 'features_area',
        'type'          => 'url',
        'label'         => __( 'Add "Button" link here', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'features_btntxtclr', 'features_area', 'Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'features_btntxthvclr', 'features_area', 'Button Text Hover Color', '#000');

addColorPalatOption($wp_customize, 'features_btnBGclr', 'features_area', 'Button BG Color', '#E3394D');

addColorPalatOption($wp_customize, 'features_btnBGhvclr', 'features_area', 'Button BG Hover Color', '#fff');

// Right side

lzCustomLable($wp_customize, 'abtright', 'features_area' , 'Right Side');

$wp_customize->add_setting('featuresus_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'featuresus_npp_heading',
        array(
            'settings'      => 'featuresus_npp_heading',
            'section'       => 'features_area',
            'label'         => __( 'Number Of Feature Right PLan ', 'luzuk-premium' ),
        )
    )
);    
$wp_customize->add_setting('featuresus_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 2));
$wp_customize->add_control(
    'featuresus_npp_count',
    array(
        'settings'      => 'featuresus_npp_count',
        'section'       => 'features_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Feature Right PLan To Show ', 'luzuk-premium' ),
        'choices'=>array(1,2,3)
    )
);

//features PAGES
for( $i = 1; $i <= 3; $i++ ){
    $wp_customize->add_setting(
        'featuresus_header'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'featuresus_header'.$i,
            array(
                'settings'      => 'featuresus_header'.$i,
                'section'       => 'features_area',
                'label'         => __( 'Feature Right PLan ', 'luzuk-premium' ).$i
            )
        )
    );

     $wp_customize->add_setting(
        'featuresus_page_icon'.$i,
        array(
            'default'           => 'fa fa-heart-o',
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );        
    $wp_customize->add_control(
        new luzuk_Fontawesome_Icon_Chooser(
            $wp_customize,
            'featuresus_page_icon'.$i,
            array(
                'settings'      => 'featuresus_page_icon'.$i,
                'section'       => 'features_area',
                'type'          => 'icon',
                'label'         => __( 'FontAwesome Icon', 'luzuk-premium' ),
            )
        )
    );
//lzAddImageElement($wp_customize, 'featuresus_page_icon'.$i, 'features_area', $label="Recommended Image Size: 270X175px");

lzAddElement($wp_customize, 'featuresus_page_title'.$i, 'features_area', $type = 'text', $label="Title", $callback ='luzuk_sanitize_text', $default='Loving-Kindness Meditation');

lzAddElement($wp_customize, 'featuresus_page_text'.$i, 'features_area', $type = 'textarea', $label="Text", $callback ='luzuk_sanitize_text', $default='Lorem Ipsum is simply dummy text of the printing and typesetting');

//lzAddElement($wp_customize, 'fea_rbtn'.$i, 'features_area', $type = 'text', $label="Button Text", $callback ='luzuk_sanitize_text', $default='Explore more');

//lzAddElement($wp_customize, 'luzuk_features_page_url_'.$i, 'features_area', $type = 'text', $label=" Link", $callback ='esc_url', $default='Add link here');


}


lzCustomLable($wp_customize, 'featuresarea_clr', 'features_area', 'Feature Section Color');

addColorPalatOption($wp_customize, 'features_area_pagetitle', 'features_area', 'Title Color', '#fff');

addColorPalatOption($wp_customize, 'features_textclr', 'features_area', 'Text Color', '#747474');

addColorPalatOption($wp_customize, 'features_icnclr', 'features_area', 'Icon Color', '#DA384A');

addColorPalatOption($wp_customize, 'features_icnbgclr', 'features_area', 'Icon BG Color', '#fff');

addColorPalatOption($wp_customize, 'features_icnbghvclr', 'features_area', 'Icon Hover BG Color', '#1C202B');

addColorPalatOption($wp_customize, 'features_icnbrdhvclr', 'features_area', 'Icon Hover Border Color', '#fff');