<?php 
 
$wp_customize->add_section(
	'gallery_section',
	array(
		'title'         => __( 'Gallery Section', 'Luzuk' ),
		'panel'   => 'luzuk_premium_home_panel',
	)
);
$wp_customize->add_setting(
	'gallery_section_disable',
	array(
		'sanitize_callback' => 'luzuk_sanitize_text',
		'default' => 'off'
	)
);
$wp_customize->add_control(
	new luzuk_Switch_Control(
		$wp_customize,
		'gallery_section_disable',
		array(
			'settings'      => 'gallery_section_disable',
			'section'       => 'gallery_section',
			'label'         => __( 'Disable Section', 'Luzuk' ),
			'on_off_label'  => array(
				'on' => __( 'Yes', 'Luzuk' ),
				'off' => __( 'No', 'Luzuk' )
			)   
		)
	)
);

backgroundManager($wp_customize, 'gallery', 'gallery_section', $color='#1C202B');

lzCustomLable($wp_customize, 'luzuk_sec_gallerysectionpadding', 'gallery_section', 'Section Padding');

$wp_customize->add_setting(
    'secgalleryTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'secgalleryTpadding',
    array(
        'settings'      => 'secgalleryTpadding',
        'section'       => 'gallery_section',
        'type'          => 'text',
        'label'         => __( 'Top ', 'luzuk' )
    )
);
$wp_customize->add_setting(
    'secgalleryBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk' )
    )
);
$wp_customize->add_control(
    'secgalleryBpadding',
    array(
        'settings'      => 'secgalleryBpadding',
        'section'       => 'gallery_section',
        'type'          => 'text',
        'label'         => __( 'Bottom ', 'luzuk' )
    )
);

lzCustomLable($wp_customize, 'sec_galleryhead', 'gallery_section', 'Section Sub Heading & Heading ');

$wp_customize->add_setting(
    'gallery_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our Gallery', 'luzuk' )
    )
);
$wp_customize->add_control(
    'gallery_subtitle',
    array(
        'settings'      => 'gallery_subtitle',
        'section'       => 'gallery_section', 
        'type'          => 'text',
        'label'         => __( 'Section Sub Heading', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'gallery_subheading', 'gallery_section', 'Section Sub Heading Color', '#DA384A');

$wp_customize->add_setting(
    'gallery_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Gallery', 'luzuk' )
    )
);
$wp_customize->add_control(
    'gallery_maintitle',
    array(
        'settings'      => 'gallery_maintitle',
        'section'       => 'gallery_section', 
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'gallery_heading', 'gallery_section', 'Section Heading Color', '#fff');


$wp_customize->add_setting('gallery_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Info_Text( 
		$wp_customize,
		'gallery_section_lbl',
		array(
			'settings'		=> 'gallery_section_lbl',
			'section'		=> 'gallery_section',
			'label'			=> __( 'Note:', 'Luzuk' ),	
			'description'	=> __( 'Use Gallery Images Of Equal Height.{400px*400px}', 'Luzuk' ),
		)
	)
);

$wp_customize->add_setting('luzuk_gallery_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
	new luzuk_Customize_Heading(
		$wp_customize,
		'luzuk_gallery_npp_heading',
		array(
			'settings'      => 'luzuk_gallery_npp_heading',
			'section'       => 'gallery_section',
			'label'         => __( 'Number Of Gallery Images To Show', 'luzuk' ),
		)
	)
);    

$wp_customize->add_setting('gallery_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 5));
$wp_customize->add_control(
	'gallery_npp_count',
	array(
		'settings'      => 'gallery_npp_count',
		'section'       => 'gallery_section',
		'type'          => 'select',
		'label'         => __( 'Number Of Gallery Images To Show', 'luzuk' ),
		'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
	)
);


$luzukGallerySingleChoice[] = 'Select';

for( $i = 1; $i <= 12; $i++ ){
	$wp_customize->add_setting(
		'rg_gallery_heading'.$i,
		array(
			'sanitize_callback' => 'luzuk_sanitize_text'
		)
	);
	$wp_customize->add_control(
		new luzuk_Customize_Heading(
			$wp_customize,
			'rg_gallery_heading'.$i,
			array(
				'settings'      => 'rg_gallery_heading'.$i,
				'section'       => 'gallery_section',
				'label'         => __( 'Gallery Image ', 'Luzuk' ).$i, 
			)
		)
	);
	if(is_array($luzukGallerySingleChoice)){
		$wp_customize->add_setting(
			'gallery_page'.$i,
			array(
				'sanitize_callback' => 'absint'
			)
		);
		$wp_customize->add_control(
			'gallery_page'.$i,
			array(
				'settings'      => 'gallery_page'.$i,
				'section'       => 'gallery_section',
				'type'=> 'select',
				'label'         => __( 'Select A Gallery Image', 'Luzuk' ),
				'choices' => $luzukGallerySingleChoice,
			)
		);
	}else{
		$wp_customize->add_setting('gallery_section_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
		$wp_customize->add_control(
			new luzuk_Info_Text( 
				$wp_customize,
				'gallery_section_lbl'.$i,
				array(
					'settings'		=> 'gallery_section_lbl'.$i,
					'section'		=> 'gallery_section',
					'label'			=> __( 'Note:', 'Luzuk' ),	
					'description'	=> __( '<strong>Changes will not reflect unless you select the gallery Image.</strong> <br/>Please add the gallery images from "Gallery menu" and then select gallery Image to show.', 'Luzuk' ),
				)
			)
		);
	}
}


lzCustomLable($wp_customize, 'luzuk_sec_galleryclr', 'gallery_section', 'Section Color');

addColorPalatOption($wp_customize, 'gall_secimgbg_clr', 'gallery_section', 'Section Image Hover Color ', '#000');

addColorPalatOption($wp_customize, 'gall_secicnbgicn_clr', 'gallery_section', 'Section Image Hover Icon Color ', '#000');

addColorPalatOption($wp_customize, 'gall_secicnbgicnbg_clr', 'gallery_section', 'Section Image Hover Icon BG Color ', '#fff');

addColorPalatOption($wp_customize, 'gall_secicnbgicnbrd_clr', 'gallery_section', 'Section Image Hover Icon Border Color ', '#DA384A');

addColorPalatOption($wp_customize, 'gall_sliarrow_clr', 'gallery_section', 'Section Slider Arrow Color ', '#fff');

addColorPalatOption($wp_customize, 'gall_sliarrowbgclr', 'gallery_section', 'Section Slider Arrow BG Color ', '#DA384A');

addColorPalatOption($wp_customize, 'gall_sliarrowbghvclr', 'gallery_section', 'Section Slider Arrow BG Hover Color ', '#000');