<?php
$wp_customize->add_section(
    'newsletter_area',
    array(
        'title' => __('Newsletter Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel'
    )
);
$wp_customize->add_setting(
    'newsletter_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);

$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'newsletter_area_disable',
        array(
            'settings'      => 'newsletter_area_disable',
            'section'       => 'newsletter_area',
            'label'         => __( 'Disable Section', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk-premium' ),
                'off' => __( 'No', 'luzuk-premium' )
            ),
        )
    )
);

backgroundManager($wp_customize, 'newsletter', 'newsletter_area', $color='#1C202B', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'newsletterarea_innbx', 'newsletter_area', 'Section Inner Box Image');

backgroundManager($wp_customize, 'newsletterinn', 'newsletter_area', $color='#fff', get_template_directory_uri().'/images/newslatter.jpg', 'color');

addColorPalatOption($wp_customize, 'news_imgolr1', 'newsletter_area', 'Image Overlay Color 1', '#1C202B');

addColorPalatOption($wp_customize, 'news_imgolr2', 'newsletter_area', 'Image Overlay Color 2', '#800719');

lzCustomLable($wp_customize, 'newsletterarea_padding', 'newsletter_area', 'Section Padding');

$wp_customize->add_setting(
    'newsletter_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_areaTpadding',
    array(
        'settings'      => 'newsletter_areaTpadding',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'newsletter_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '8em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_areaBpadding',
    array(
        'settings'      => 'newsletter_areaBpadding',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Bottom ', 'luzuk-premium' )
    )
);

$wp_customize->add_setting(
    'newsletter_page_maintitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text'
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'newsletter_page_maintitle_heading',
        array(
            'settings'      => 'newsletter_page_maintitle_heading',
            'section'       => 'newsletter_area',
            'label'         => __( 'Section Heading', 'luzuk-premium' ),
        )
    )
);    
 
$wp_customize->add_setting(
    'newsletter_page_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'SUBSCRIBE OUR NEWSLETTER', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'newsletter_page_maintitle',
    array(
        'settings'      => 'newsletter_page_maintitle',
        'section'       => 'newsletter_area',
        'type'          => 'text',
        'label'         => __( 'Heading For Section', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'newsletterarea_title_color', 'newsletter_area', 'Section Heading Color', '#fff');

$wp_customize->add_setting(
    'news_text',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'There are many variations of passages of Lorem Ipsum available', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'news_text',
    array(
        'settings'      => 'news_text',
        'section'       => 'newsletter_area',
        'type'          => 'textarea',
        'label'         => __( 'Section Text', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'newsletterarea_text_color', 'newsletter_area', 'Section Text Color', '#7b7e7e');

lzCustomLable($wp_customize, 'newsletter_Form_label', 'newsletter_area', 'Newsletter Form Shortcode');

lzAddElement($wp_customize, 'luzuk_newsletter_shortcode', 'newsletter_area', 'textarea', $label="Form Shortcode", 'luzuk_sanitize_text', '[your shortcode]');

addColorPalatOption($wp_customize, 'newsletter_forminputtextColor', 'newsletter_area', 'Form Input text / Placeholder Color', '#adb2b2');

addColorPalatOption($wp_customize, 'newsletter_formborderColor', 'newsletter_area', 'Form Input Border Color', '#EC1F24');

addColorPalatOption($wp_customize, 'newsletter_formbuttontextColor', 'newsletter_area', 'Form Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'newsletter_formbuttontexthoverColor', 'newsletter_area', 'Form Button Text Hover Color', '#000');

addColorPalatOption($wp_customize, 'newsletter_formbuttonbgColor1', 'newsletter_area', 'Form Button BG Color', '#F63954');

addColorPalatOption($wp_customize, 'newsletter_formbtnbghvClr', 'newsletter_area', 'Form Button BG Hover Color', '#fff');

addColorPalatOption($wp_customize, 'newsletter_fmsmbxbgClr', 'newsletter_area', 'Small Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'newsletter_textClr', 'newsletter_area', 'Text Color', '#fff');

addColorPalatOption($wp_customize, 'newsletter_textdotClr', 'newsletter_area', 'Text Dot Color', '#F63954');