<?php  
/**
 * Createing an services pannel for customizer
 *
 */
// START services SECTION 
    $wp_customize->add_section(
        'video_box',
        array(
            'title' => __( 'Video Section', 'luzuk premium' ),
            'panel' => 'luzuk_premium_home_panel'
        )
    );
    // ENABLE/DISABLE FEATURED SECTION
    $wp_customize->add_setting(
        'video_box_disable',
        array(
            'sanitize_callback' => 'luzuk_sanitize_text',
        )
    );
    $wp_customize->add_control(
        new luzuk_Switch_Control(
            $wp_customize,
            'video_box_disable',
            array(
                'settings'      => 'video_box_disable',
                'section'       => 'video_box',
                'label'         => __( 'Disable Section', 'luzuk premium' ),
                'on_off_label'  => array(
                    'on' => __( 'Yes', 'luzuk premium' ),
                    'off' => __( 'No', 'luzuk premium' )
                ),
            )
        )
    );

backgroundManager($wp_customize, 'video_sectimg', 'video_box', $color='#1C202B', get_template_directory_uri().'/images/default-gray.png', 'img'); 


//Section Video Padding
lzCustomLable($wp_customize, 'videosec_padding', 'video_box', ' Section Padding ');

$wp_customize->add_setting(
    'videosec_toppadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '8em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'videosec_toppadding',
    array(
        'settings'      => 'videosec_toppadding',
        'section'       => 'video_box',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'videosec_bottompadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '4em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'videosec_bottompadding',
    array(
        'settings'      => 'videosec_bottompadding',
        'section'       => 'video_box',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);

// backgroundManager($wp_customize, 'video_lefttimg', 'video_box', $color='#fff', get_template_directory_uri().'/images/video.jpg', 'color'); 

lzCustomLable($wp_customize, 'Sec_vimg', 'video_box' , 'Video Image');

$wp_customize->add_setting(
    'vbabt_image',
    array(
        'sanitize_callback' => 'esc_url_raw'
    )
);

$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'vbabt_image',
        array(
            'section' => 'video_box',
            'settings' => 'vbabt_image',
            'description' => __('Recommended Image Size: 1200X600px', 'luzuk-premium')
        )
    )
);
// ADDRESS GOOGLE/MSN/OTHER video IFRAME OR EMBADE CODE
$wp_customize->add_setting('luzuk_abt_vb_embade_iframe_lbl', array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
  new luzuk_Customize_Heading($wp_customize, 'luzuk_abt_vb_embade_iframe_lbl',
    array(
      'settings'      => 'luzuk_abt_vb_embade_iframe_lbl',
      'section'       => 'video_box',
      'label'         => __( 'Video Embeded Code', 'luzuk premium' ),
    )
  )
);

// end to show & hide button
// field for addeding the video code
$wp_customize->add_setting('luzuk_abt_vb_embade', array(/*'sanitize_callback' => 'esc_url_raw',*/ 'default'=>'Add your video embade code'));

$wp_customize->add_control('luzuk_abt_vb_embade', array('settings'=>'luzuk_abt_vb_embade', 'section'=>'video_box','type'=>'textarea', 'label'=> __('Code For Video', 'luzuk premium')));

lzCustomLable($wp_customize, 'Sec_videoclr', 'video_boxclr' , 'Section Color');

addColorPalatOption($wp_customize, 'videobuticon_color', 'video_box', 'Play Button Icon Color', '#FF0024');

