<?php 
$wp_customize->add_section(
    'service_area',
    array(
        'title'         => __( 'Services Section', 'luzuk' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
$wp_customize->add_setting(
    'service_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'service_area_disable',
        array(
            'settings'      => 'service_area_disable',
            'section'       => 'service_area',
            'label'         => __( 'Disable Section', 'luzuk' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk' ),
                'off' => __( 'No', 'luzuk' )
            )   
        )
    )
);

backgroundManager($wp_customize, 'service', 'service_area', $color='#1C202B', get_template_directory_uri().'/images/default.png', 'img');

lzCustomLable($wp_customize, 'luzuk_sec_servicessectionpadding', 'service_area', 'Section Padding');

$wp_customize->add_setting(
    'service_areaTpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaTpadding',
    array(
        'settings'      => 'service_areaTpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk-premium' )
    )
);
$wp_customize->add_setting(
    'service_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2em', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'service_areaBpadding',
    array(
        'settings'      => 'service_areaBpadding',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk-premium' )
    )
);


$wp_customize->add_setting(
    'services_maintitle_subtitle_heading',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'services_maintitle_subtitle_heading',
        array(
            'settings'      => 'services_maintitle_subtitle_heading',
            'section'       => 'service_area',
            'label'         => __( 'Section Sub Heading & Heihlight', 'luzuk' ),
        )
    )
);


$wp_customize->add_setting(
    'sersubtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our Service', 'luzuk' )
    )
);
$wp_customize->add_control(
    'sersubtitle',
    array(
        'settings'      => 'sersubtitle',
        'section'       => 'service_area', 
        'type'          => 'text',
        'label'         => __( 'Section Sub Heading', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'sersec_subheading_clr', 'service_area', 'Section Sub Heading Color ', '#DA384A');

$wp_customize->add_setting(
    'services_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'The Target Audience For Your Service.', 'luzuk' )
    )
);
$wp_customize->add_control(
    'services_maintitle',
    array(
        'settings'      => 'services_maintitle',
        'section'       => 'service_area', 
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'sersec_heading_clr', 'service_area', 'Section Heading Color ', '#1C202B');


$wp_customize->add_setting('service_area_lbl2', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'service_area_lbl2',
        array(
            'settings'      => 'service_area_lbl2',
            'section'       => 'service_area',
            'label'         => __( 'Note 2 :', 'luzuk' ),  
            'description'   => __( 'Use Shortcode [SERVICES] to show all services in a page', 'luzuk' ),
        )
    )
);


$wp_customize->add_setting('service_npp_heading',array('sanitize_callback' => 'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Customize_Heading(
        $wp_customize,
        'service_npp_heading',
        array(
            'settings'      => 'service_npp_heading',
            'section'       => 'service_area',
            'label'         => __( 'Number Of Services To Show', 'luzuk' ),
        )
    )
);    
$wp_customize->add_setting('service_npp_count',array('sanitize_callback' => 'luzuk_sanitize_text','default' => 3));
$wp_customize->add_control(
    'service_npp_count',
    array(
        'settings'      => 'service_npp_count',
        'section'       => 'service_area',
        'type'          => 'select',
        'label'         => __( 'Number Of Services To Show', 'luzuk' ),
        'choices'=>array(1,2,3,4,5,6,7,8,9,10,11,12)
    )
);

$ServicesSingleChoice[] = 'Select';

for( $i = 1; $i <= 12; $i++ ){
    $wp_customize->add_setting(
        'services_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'services_heading'.$i,
            array(
                'settings'      => 'services_heading'.$i,
                'section'       => 'service_area',
                'label'         => __( 'Service ', 'luzuk' ).$i,
            )
        )
    );
    if(is_array($ServicesSingleChoice)){
        $wp_customize->add_setting(
            'services_page'.$i,
            array(
                'sanitize_callback' => 'absint'
            )
        );
        $wp_customize->add_control(
            'services_page'.$i,
            array(
                'settings'      => 'services_page'.$i,
                'section'       => 'service_area',
                'type'=> 'select',
                'label'         => __( 'Select A Service Box ', 'luzuk' ),
                'choices' => $ServicesSingleChoice,
            )
        );

// $wp_customize->add_setting(
//         'services_page_icon1'.$i,
//         array(
//             'default'           => 'fa fa-user-o',
//             'sanitize_callback' => 'luzuk_sanitize_text'
//         )
//     );        
//     $wp_customize->add_control(
//         new luzuk_Fontawesome_Icon_Chooser(
//             $wp_customize,
//             'services_page_icon1'.$i,
//             array(
//                 'settings'      => 'services_page_icon1'.$i,
//                 'section'       => 'service_area',
//                 'type'          => 'icon',
//                 'label'         => __( 'FontAwesome Icon', 'luzuk' ),
//             )
//         )
//     );



    }else{
        $wp_customize->add_setting('service_area_lbl'.$i, array('sanitize_callback'=>'luzuk_sanitize_text'));
        $wp_customize->add_control(
            new luzuk_Info_Text( 
                $wp_customize,
                'service_area_lbl'.$i,
                array(
                    'settings'      => 'service_area_lbl'.$i,
                    'section'       => 'service_area',
                    'label'         => __( 'Note:', 'luzuk' ),    
                    'description'   => __( '<strong>Changes will not reflect unless you select the Service Page.</strong> <br/>Please add the Services from "Services menu" and then select Services to show information.', 'luzuk' ),
                )
            )
        );
    }
}

lzCustomLable($wp_customize, 'luzuk_sec_servicesclr', 'service_area', 'Service Section Color');

addColorPalatOption($wp_customize, 'sersec_boxbgclr', 'service_area', 'Section Box BG Color ', '#fff');

addColorPalatOption($wp_customize, 'sersec_titebgclr', 'service_area', 'Section Title BG Color ', '#000');

addColorPalatOption($wp_customize, 'services_secTitleClr', 'service_area', 'Section Title Color ', '#fff');

//addColorPalatOption($wp_customize, 'services_secTitlehvClr', 'service_area', 'Section Title Hover Color ', '#000');

addColorPalatOption($wp_customize, 'services_sectxtlClr', 'service_area', 'Section Text Color ', '#716d6d');


lzCustomLable($wp_customize, 'luzuk_secser_sbtnclr', 'service_area', 'Section Button Setting');

$wp_customize->add_setting(
    'ser_button1',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'FIND OUT MORE', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'ser_button1',
    array(
        'settings'      => 'ser_button1',
        'section'       => 'service_area',
        'type'          => 'text',
        'label'         => __( 'Button Text', 'luzuk-premium' )
    )
);


addColorPalatOption($wp_customize, 'services_btnarowclr', 'service_area', 'Section Button Text Color ', '#fff');

addColorPalatOption($wp_customize, 'services_btnarowhvclr', 'service_area', 'Section Button Text Hover Color ', '#000');

addColorPalatOption($wp_customize, 'services_btnarowbgclr', 'service_area', 'Section Button BG Color ', '#E3394D');

addColorPalatOption($wp_customize, 'services_btnarowbghvclr', 'service_area', 'Section Button BG Hover Color ', '#000');

addColorPalatOption($wp_customize, 'ser_slidebtnbgclr', 'service_area', 'Section Slider Button BG Color ', '#000');

addColorPalatOption($wp_customize, 'ser_slidebtnicnclr', 'service_area', 'Section Slider Button Icon Color ', '#fff');

addColorPalatOption($wp_customize, 'ser_slidebtnicnhvclr', 'service_area', 'Section Slider Button Icon Hover Color ', '#E3394D');