<?php

$lzFitnessSliderSingleChoice = getFitnessPostsType('slider');

// CREATING A SECTION IN CUSTOMIZER
$wp_customize->add_section(
    'premium_slider_section',
    array(
        'title' => __( 'Slider Section', 'luzuk-premium' ),
        'panel' => 'luzuk_premium_home_panel',
        'priority' =>18
    )
);

// show content in slider
$wp_customize->add_setting(
    'premium_slider_show_content',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'premium_slider_show_content',
        array(
            'settings'      => 'premium_slider_show_content',
            'section'       => 'premium_slider_section',
            'label'         => __( 'Hide Title And Description On Slider', 'luzuk-premium' ),
            'on_off_label'  => array(
                'on' => __( 'No', 'luzuk-premium' ),
                'off' => __( 'Yes', 'luzuk-premium' )
            ),
        )
    )
);

$wp_customize->add_setting('luzuk_premium_slider_section_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_slider_section_lbl',
        array(
            'settings'      => 'luzuk_premium_slider_section_lbl',
            'section'       => 'premium_slider_section',
            'label'         => __( 'Note:', 'luzuk-premium' ),  
            'description'   => __( 'The Page featured image works as a slider banner and the title & content work as a slider caption. And you can add this from the Slider menu. <br/> Recommended Image Size: 566X566', 'luzuk-premium' ),
        )
    )
);

lzCustomLable($wp_customize, 'slider_anefect', 'premium_slider_section', 'Section Animation Effects');

///THeme all bubbles
$wp_customize->add_setting( 'slideram_button_display' , array( 'default' => true, 'transport' => 'refresh', ) ); 
$wp_customize->add_control( 'slideram_button_display', array( 'label' => 'Slider Animation Effects Display Settings', 'section' => 'premium_slider_section', 'settings' => 'slideram_button_display', 'type' => 'radio', 'choices' => array( 'show' => ' Show', 'hide' => ' Hide', ), ) ); 


backgroundManager($wp_customize, 'main-slide', 'premium_slider_section', $color='#fff', get_template_directory_uri().'/images/sliderbg.jpg', 'color');

lzCustomLable($wp_customize, 'slider_imgoly', 'premium_slider_section', 'Image Overlay Opacity ');

$wp_customize->add_setting(
    'slider_areaOpacity',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '0.95', 'luzuk-premium' )
    )
);
$wp_customize->add_control(
    'slider_areaOpacity',
    array(
        'settings'      => 'slider_areaOpacity',
        'section'       => 'premium_slider_section',
        'type'          => 'text',
        'label'         => __( 'Opacity', 'luzuk-premium' )
    )
);

addColorPalatOption($wp_customize, 'slider_opciyt1', 'premium_slider_section', 'Opacity Color 1', '#1C202B');

addColorPalatOption($wp_customize, 'slider_opciyt2', 'premium_slider_section', 'Opacity Color 2', '#E3394D');

lzCustomLable($wp_customize, 'slider_color', 'premium_slider_section', 'Section Color');

addColorPalatOption($wp_customize, 'slider_SltitleColor', 'premium_slider_section', 'Slider Title Color', '#fff');

addColorPalatOption($wp_customize, 'slider_SubtitleColor', 'premium_slider_section', 'Slider Text Color', '#b3afaf');


lzCustomLable($wp_customize, 'slider_fristbtn', 'premium_slider_section', 'Slider Frist Button Color');

addColorPalatOption($wp_customize, 'slider_btntxt', 'premium_slider_section', 'First Button Text Color', '#000');

addColorPalatOption($wp_customize, 'slider_btntxthv', 'premium_slider_section', 'First Button Text Hover Color', '#E3394D');

addColorPalatOption($wp_customize, 'slider_btntxtbg', 'premium_slider_section', 'First Button BG Color', '#fff');

addColorPalatOption($wp_customize, 'slider_btntxtbghv', 'premium_slider_section', 'First Button BG Hover Color', '#000');


lzCustomLable($wp_customize, 'slider_secndbtn', 'premium_slider_section', 'Slider Second Button Color');

addColorPalatOption($wp_customize, 'slider2nd_btntxt', 'premium_slider_section', 'Second Button Text Color', '#fff');

addColorPalatOption($wp_customize, 'slider2nd_btntxthv', 'premium_slider_section', 'Second Button Text Hover Color', '#000');

addColorPalatOption($wp_customize, 'slider2nd_btnbghv', 'premium_slider_section', 'Second Button BG Hover Color 1', '#fff');

addColorPalatOption($wp_customize, 'slider2nd_btnbrd', 'premium_slider_section', 'Second Button Border Color 2', '#000');


lzCustomLable($wp_customize, 'slider_slidearrowbtn', 'premium_slider_section', 'Slider Arrow Button Color');

addColorPalatOption($wp_customize, 'sliderarow_arrowbgclr', 'premium_slider_section', 'Arrow BG Color ', '#000');

addColorPalatOption($wp_customize, 'sliderarow_arrowclr', 'premium_slider_section', 'Arrow Color ', '#fff');

addColorPalatOption($wp_customize, 'sliderarow_arrowhvclr', 'premium_slider_section', 'Arrow Hover Color ', '#E3394D');
