<?php  
// TESTIMONIALS SECTION START HERE 

$wp_customize->add_section(
    'testimonials_area',
    array(
        'title'         => __( 'Testimonial Section', 'luzuk Premium' ),
        'panel'   => 'luzuk_premium_home_panel',
    )
);
    //ENABLE/DISABLE TESTIMONIALS SECTION
$wp_customize->add_setting(
    'testimonials_area_disable',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default' => 'off'
    )
);
$wp_customize->add_control(
    new luzuk_Switch_Control(
        $wp_customize,
        'testimonials_area_disable',
        array(
            'settings'      => 'testimonials_area_disable',
            'section'       => 'testimonials_area',
            'label'         => __( 'Disable Section', 'luzuk Premium' ),
            'on_off_label'  => array(
                'on' => __( 'Yes', 'luzuk Premium' ),
                'off' => __( 'No', 'luzuk Premium' )
            )   
        ) 
    )
);
 
backgroundManager($wp_customize, 'testimonials', 'testimonials_area', $color='#000', get_template_directory_uri().'/images/default-gray.png', 'img');

lzCustomLable($wp_customize, 'luzuk_sec_testsectionpadding', 'testimonials_area', 'Section Padding ');

$wp_customize->add_setting(
    'testimonials_areaTpadding', 
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '2.5em', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaTpadding',
    array(
        'settings'      => 'testimonials_areaTpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Top', 'luzuk Premium' )
    )
);
$wp_customize->add_setting(
    'testimonials_areaBpadding',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( '8em', 'luzuk Premium' )
    )
);
$wp_customize->add_control(
    'testimonials_areaBpadding',
    array(
        'settings'      => 'testimonials_areaBpadding',
        'section'       => 'testimonials_area',
        'type'          => 'text',
        'label'         => __( 'Bottom', 'luzuk Premium' )
    )
);



lzCustomLable($wp_customize, 'sec_testimonialhead', 'testimonials_area', 'Section Sub Heading & Heading ');

$wp_customize->add_setting(
    'testi_subtitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Our Testimonials', 'luzuk' )
    )
);
$wp_customize->add_control(
    'testi_subtitle',
    array(
        'settings'      => 'testi_subtitle',
        'section'       => 'testimonials_area', 
        'type'          => 'text',
        'label'         => __( 'Section Sub Heading', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'testi_subheading', 'testimonials_area', 'Section Sub Heading Color', '#DA384A');

$wp_customize->add_setting(
    'testi_maintitle',
    array(
        'sanitize_callback' => 'luzuk_sanitize_text',
        'default'           => __( 'Clients Words About Us', 'luzuk' )
    )
);
$wp_customize->add_control(
    'testi_maintitle',
    array(
        'settings'      => 'testi_maintitle',
        'section'       => 'testimonials_area', 
        'type'          => 'text',
        'label'         => __( 'Section Heading', 'luzuk' )
    )
);

addColorPalatOption($wp_customize, 'testi_heading', 'testimonials_area', 'Section Heading Color', '#fff');

$TesimonialsSingleChoice[] = 'select';
if(!is_array($TesimonialsSingleChoice)){
    $wp_customize->add_setting('testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
    $wp_customize->add_control(
        new luzuk_Info_Text( 
            $wp_customize,
            'testimonials_area_lbl',
            array(
                'settings'      => 'testimonials_area_lbl',
                'section'       => 'testimonials_area',
                'label'         => __( 'Note:', 'luzuk Premium' ), 
                'description'   => __( '<strong>Changes will not reflect unless you select the Testimonials.</strong> <br/>Please add the Testimonials from "Testimonials menu" and then select Testimonial to show information.', 'luzuk Premium' ),
            )
        )
    );
}
$wp_customize->add_setting('luzuk_premium_testimonials_area_lbl', array('sanitize_callback'=>'luzuk_sanitize_text'));
$wp_customize->add_control(
    new luzuk_Info_Text( 
        $wp_customize,
        'luzuk_premium_testimonials_area_lbl',
        array(
            'settings'      => 'luzuk_premium_testimonials_area_lbl',
            'section'       => 'testimonials_area',
            'label'         => __( 'Note:', 'luzuk Premium' ), 
            'description'   => __( 'Just place the shortcode "[TESTIMONIALS]" in your page to list the Testimonials in a page ', 'luzuk Premium' ),
        )
    )
);
//TESTIMONIALS PAGES
for( $i = 1; $i < 9; $i++ ){
    $wp_customize->add_setting(
        'luzuk_testimonials_heading'.$i,
        array(
            'sanitize_callback' => 'luzuk_sanitize_text'
        )
    );
    $wp_customize->add_control(
        new luzuk_Customize_Heading(
            $wp_customize,
            'luzuk_testimonials_heading'.$i,
            array(
                'settings'      => 'luzuk_testimonials_heading'.$i,
                'section'       => 'testimonials_area',
                'label'         => __( 'Testimonial ', 'luzuk Premium' ).$i,
            )
        )
    );
    $wp_customize->add_setting(
        'testimonials_page'.$i,
        array(
            'sanitize_callback' => 'absint'
        )
    );
    $wp_customize->add_control(
        'testimonials_page'.$i,
        array(
            'settings'      => 'testimonials_page'.$i,
            'section'       => 'testimonials_area',
            'type'=> 'select',
            'label'         => __( 'Select A Client Testimonial', 'luzuk Premium' ),
            'choices' => $TesimonialsSingleChoice,
        )
    );
}


lzCustomLable($wp_customize, 'clientcolor', 'testimonials_area', 'Testimonial Section Color');


addColorPalatOption($wp_customize, 'testi_bxBGclr', 'testimonials_area', 'Section Box BG Color', '#fff');

addColorPalatOption($wp_customize, 'testi_dicnclr', 'testimonials_area', 'Section Box Icon Color', '#e2e2e2');

addColorPalatOption($wp_customize, 'testi_dicnhvclr', 'testimonials_area', 'Section Box Icon Hover Color', '#DA384A');

addColorPalatOption($wp_customize, 'testi_Nameclr', 'testimonials_area', 'Section Client Name Color', '#1C202B');

addColorPalatOption($wp_customize, 'test_deginclr', 'testimonials_area', 'Section Client Designation Color', '#DA384A');

addColorPalatOption($wp_customize, 'testicontent_textclr', 'testimonials_area', ' Section Text Color', '#877777');

addColorPalatOption($wp_customize, 'testi_slidearrowbgclr', 'testimonials_area', 'Section Slider Arrow Button BG Color', '#DA384A');

addColorPalatOption($wp_customize, 'testi_slidearrowbghvclr', 'testimonials_area', 'Section Slider Arrow Button BG Hover Color', '#000');

addColorPalatOption($wp_customize, 'testi_slidearrowclr', 'testimonials_area', 'Section Slider Arrow Color', '#fff');