<?php
/**
 * Template Name: Contact Page
 *
 * @package luzuk Premium
 */
get_header(); 
?>

<?php $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));?>
<header class="page-main-header" <?php  if (!empty($image)) : ?> style="background: url('<?php echo esc_url($image); ?>'); background-repeat: no-repeat; background-size:cover; position: relative;"<?php endif ?> >
    <div class="overlay1"></div>
    <div class="container">
        <?php the_title( '<h1 class="ht-main-title">', '</h1>' ); ?>

        <?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'show') : ?>
        <div class="breadcrumbbox ">
            <div class='button'> <?php luzuk_lite_the_breadcrumb(); ?> </div>
            <div class="clearfix"></div>
        </div>
        <?php endif ?>
        <div class="holocir1"></div>
        <div class="holocir2"></div>
        <div class="smcir"></div>
        <div class="smcir2"></div>
        <div class="clearfix"></div>
    </div>
    <div class="clearfix"></div>
</header>

<main id="innerpage-box" >
	<div class="container">
		<div class="contact-address-area">
			<div class="row mr-0">	
				<div class="col-lg-3 col-md-5 col-sm-6 ">
					<?php 
						$bx1_tlte = get_theme_mod('bx1tlte', 'CONTACT INFO');
						$bx1_bxtxt = get_theme_mod('bx1bxtxt', 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry is standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting.');
							
						?>
					<div class="txtbx">
						<div class="bxtitle inner-area-title"><?php echo $bx1_tlte;?></div>	
						<div class="bxtxt "><?php echo $bx1_bxtxt;?></div> 

						<?php
							$cntbtn_text = get_theme_mod('cntbtn_text', 'Read More');
							$cntbtnlink = get_theme_mod('cntbtnlink', '#');
						?>
						<div class="cnt-btn btn">
							<?php if($cntbtn_text ){ ?>	
							<a href="<?php echo ($cntbtnlink);  ?>">
									<?php echo ($cntbtn_text);  ?>
							</a>
							<?php }?>
						</div>
				    </div>
				</div>	
				<div class="col-lg-4 col-md-7 col-sm-6">
					<div class="cntlhsbx">
					<?php 
						$phonetitle = get_theme_mod('luzuk_contactus_phonetitle', 'Phone : ');
						$phone = get_theme_mod('luzuk_contactus_phone', '+123 456 789');
				  		
				  		$emailtitle = get_theme_mod('luzuk_contactus_emailtitle', 'Email : ');
						$email = get_theme_mod('luzuk_contactus_email', 'info@youremailidhere.com');
				    	
				    	$addresstitle = get_theme_mod('luzuk_contactus_addresstitle', 'Address : ');
						$address = get_theme_mod('luzuk_contactus_address', 'Add Address here..');

						$timetitle = get_theme_mod('contactus_timetitle', 'Time : ');
						$time = get_theme_mod('contactus_time', 'Mon-Sat 9:00 - 7:00');	
					?>		
						<div class="conbx ">		
							<div class="row mr-0">	
				    			<?php if( $phonetitle || $phone ){ ?>
						   		<div class="col-md-6 cntpgbx  p-box">		
						   			<div class="cntpgicn">
					   					<i class="fa fa-phone" ></i> 
						   			</div>	
							   		<div class=" cntpgtxt">
							   			<h3><?php echo $phonetitle;?></h3>
						   			</div>
						   			<a class="" href="tel:<?php echo $phone;?>"><p><?php echo $phone;?></p></a>
							   		<div class="clearfix"></div>
							   	</div>
								 <?php } ?>	

								<?php if( $emailtitle || $email  ){ ?>
								<div class="col-md-6 cntpgbx e-box">
							   		<div class="cntpgicn">
							   			<i class="fa fa-envelope" ></i>
							   		</div>
							   		<div class=" cntpgtxt">
							   			<h3><?php echo $emailtitle;?></h3>
							   		</div>
								   	<a href="mailto:<?php echo $email;?>"><p><?php echo $email;?></p></a>
								   	<div class="clearfix"></div>
							    </div>
								<?php } ?>	

								<?php if( $addresstitle || $address ){ ?>
								<div class="col-md-6 cntpgbx a-box">
							   		<div class="cntpgicn">
							   			<i class="fa fa-map-marker" ></i>
							   		</div>
								   		
							   		<div class="cntpgtxt">
							   			<h3><?php echo $addresstitle;?></h3>
							   		</div>
								   	<p><?php echo $address;?></p>	
								   	<div class="clearfix"></div>
							    </div>
								<?php } ?>

								<?php if( $timetitle || $time ){ ?>
								<div class="col-md-6 cntpgbx t-box">
									<div class="row mr-0">
								   		<div class="cntpgicn">
								   			<i class="fa fa fa-clock-o" ></i>
								   		</div>
								   		<div class=" cntpgtxt">
								   			<h3><?php echo $timetitle;?></h3>
								   		</div>
								   		<p><?php echo $time;?></p>
									</div>
								   	<div class="clearfix"></div>
							    </div>
								<?php } ?>	
								<div class="clearfix"></div>
							</div>
						 </div>
					</div>
				</div>
				<div class="col-lg-5 col-md-12 col-sm-12 ">
					<div class="contforminn">
						<div id="ht-contactus-wrap">
							<?php 
								$shortcodeLbl = get_theme_mod('luzuk_contactus_shortcode_lbl', 'CONTACT US');
								$shortcode = get_theme_mod('luzuk_contactus_shortcode', 'Add your form shortcode customizer');
								$iframe = get_theme_mod('luzuk_contactus_embade', 'Add your Embed code in customizer');
							?>
							<div class="contact-form">
								<?php if( $shortcodeLbl  || $shortcodetxt){ ?>
								<div class="conformbx">
						         	<div class="maintle inner-area-title"><?php echo $shortcodeLbl;?></div>	
				     			</div>
				     			<?php } ?>	
				          		<div class="ctform"><?php echo do_shortcode($shortcode);?></div>		
								<div class="clearfix"></div>					
							</div>
						</div>
					</div>
				</div>
			</div>
		  	<div class="clearfix"></div>
		</div>
	</div>
		<div class="contact-mapbox">
			<?php echo $iframe; ?>
		</div>
		<div class="clearfix"></div>
</main>
<?php get_footer(); ?>