
<?php
/**
 * Template for displaying single product pages.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.0.0
 */
get_header(); ?>
<div class="clearfix"></div>
<?php $image = wp_get_attachment_url( get_post_thumbnail_id($post->ID));?>

<header class="page-main-header" <?php  if (!empty($image)) : ?> style="background: url('<?php echo esc_url($image); ?>'); background-repeat: no-repeat; background-size:cover; position: relative;"<?php endif ?> >
    <div class="overlay1"></div>
    <div class="container">
        <?php the_title( '<h1 class="ht-main-title ">', '</h1>' ); ?>

        <?php if( get_theme_mod('breadcrumb_button_display','show' ) == 'show') : ?>
        <div class="breadcrumbbox ">
            <div class='button'> <?php luzuk_lite_the_breadcrumb(); ?> </div>
            <div class="clearfix"></div>
        </div>
        <?php endif ?>
        <div class="holocir1"></div>
        <div class="holocir2"></div>
        <div class="smcir"></div>
        <div class="smcir2"></div>
        <div class="clearfix"></div>
    </div>
    <div class="clearfix"></div>
</header>

<div class="single-productpage">
	<main id="innerpage-box">
		<div id="page" class="container" >
			<div class="inner_contentbox" >		
				<article id="content" class="article single_inner">
					<?php do_action('woocommerce_before_main_content'); ?>
						<?php while ( have_posts() ) : the_post(); ?>
							<?php wc_get_template_part( 'content', 'single-product' ); ?>
						<?php endwhile; // end of the loop. ?>
				</article>
				<div class="clearfix"></div>
			</div>
			<div class="clearfix"></div>
		</div>
	</main><!-- #primary -->	
</div>
<div class="clearfix"></div>
<?php get_footer(); ?>

